//******************************************
// file			: I2C_RW_24C02_Function.c
// version		: V1.0 2019/03/20
// brief		: 24C02 related functions
// note			: 24C02 related functions are gathered in this subroutine
//******************************************   
#include "MQ6822.h"

#include".\I2C_RW_24C02_Function.h"

void Delay_24C02()
{
#pragma ASM
PUSH DE
Delay:
	LD			DE,0x0000
Delay_Loop:
	LD			(0x0FD5),0x4E
	INC			DE
	CMP			DE,0x400
	J			NE,Delay_Loop
POP DE
#pragma ENDASM
}
void Delay_NAK()
{
#pragma ASM
PUSH DE
NAK_Delay:
	LD			DE,0x0000
NAK_Delay_Loop:
	LD			(0x0FD5),0x4E					
	INC			DE
	CMP			DE,0x100
	J			NE,NAK_Delay_Loop
POP DE
#pragma ENDASM

}

void Initial_I2C()
{
P2CR.bit.b3 = 1;
P2CR.bit.b4 = 1;
P2FC.bit.b3 = 1;
P2FC.bit.b4 = 1;
__ASM("DI");
EIRH.bit.b7 = 1;
POFFCR1.bit.b4 = 1;
__ASM("EI");
}

void Write_24C02(unsigned char StartAddress,unsigned char *Data,unsigned char Length)
{      
	unsigned char i;
	
	
	
	for(i=0;i<Length;i++)
	{
	
		SBI0CR1.byte = 0x17 ; 	//Select the acknowlegment and set SBIOCR1<SCK> to "110"
		SBI0CR2.byte = 0xD8	;	//				;Select the serial bus interface mode
		while(SBI0SR2.bit.b5==1){WDCDR.byte = 0x4e;}// Confirms that the bus is free
		SBI0DBR.byte = 0xA0; //DeviceAddress[7:1] ,R/W[1/0]
		SBI0CR2.byte = 0xF8;// Select the serial bus interface mode
		while(SBI0SR2.bit.b4==1){WDCDR.byte = 0x4e;}//Confirms that the INT is released
		SBI0DBR.byte=StartAddress+i;
		SBI0CR2.byte = 0xF8;
		while(SBI0SR2.bit.b4==1){WDCDR.byte = 0x4e;}//Confirms that the INT is released
		SBI0DBR.byte = Data[i];
		SBI0CR2.byte = 0xf8;
		Delay_24C02();
		SBI0CR2.byte =0xD8; // Sets SBI0CR2<MST>, <TRX> and <PIN> to "1" and SBI0CR2<BB> to "0"
		while(SBI0SR2.bit.b5==1){WDCDR.byte = 0x4e;}// Confirms that the bus is free
		Delay_24C02();
	
	}
	
	
	
	
	
	

// 	SBI0CR1.byte = 0x17 ; 	//Select the acknowlegment and set SBIOCR1<SCK> to "110"
// 	SBI0CR2.byte = 0xD8	;	//				;Select the serial bus interface mode
// 	while(SBI0SR2.bit.b5==1){WDCDR.byte = 0x4e;}// Confirms that the bus is free
// 	SBI0DBR.byte = 0xA0; //DeviceAddress[7:1] ,R/W[1/0]
// 	SBI0CR2.byte = 0xF8;// Select the serial bus interface mode
// 	while(SBI0SR2.bit.b4==1){WDCDR.byte = 0x4e;}//Confirms that the INT is released
// 	SBI0DBR.byte=StartAddress;
// 	SBI0CR2.byte = 0xF8;
// 	
// 	//Delay_24C02();
// 	
// 	for(i=0;i<Length;i++)
// 	{	
// 		while(SBI0SR2.bit.b4==1){WDCDR.byte = 0x4e;}//Confirms that the INT is released
// 		SBI0DBR.byte = Data[i];
// 		SBI0CR2.byte = 0xf8;
// 		Delay_24C02();
// 	}
// 	//STOP
// 	SBI0CR2.byte =0xD8; // Sets SBI0CR2<MST>, <TRX> and <PIN> to "1" and SBI0CR2<BB> to "0"
// 	while(SBI0SR2.bit.b5==1){WDCDR.byte = 0x4e;}// Confirms that the bus is free
// 	Delay_24C02();
    
}
void Read_24C02(unsigned char StartAddress,unsigned char *Data,unsigned char Length)
{
	unsigned char i,Len,tmp;
	if(Length==0)return;
	
	SBI0CR1.byte = 0x17; //Select the acknowlegment and set SBIOCR1<SCK> to "110"
	SBI0CR2.byte = 0xD8; //Select the serial bus interface mode	
	while(SBI0SR2.bit.b5==1){WDCDR.byte = 0x4e;}// Confirms that the bus is free
	SBI0DBR.byte =0xA0; 		//DeviceAddress[7:1] ,R/W[1/0]
	SBI0CR2.byte =0xF8; 		//Select the serial bus interface mode
	while(SBI0SR2.bit.b4==1){WDCDR.byte = 0x4e;}//Confirms that the INT is released
	SBI0DBR.byte=StartAddress;
	SBI0CR2.byte = 0xF8;
	Delay_24C02();
	SBI0CR1.byte = 0x17;//;Select the acknowlegment and set SBIOCR1<SCK> to "110"
	SBI0CR2.byte = 0xd8;//;Select the serial bus interface mode
	while(SBI0SR2.bit.b5==1){WDCDR.byte = 0x4e;}// Confirms that the bus is free
	SBI0DBR.byte =0xA1; 		//DeviceAddress[7:1] ,R/W[1/0]
	SBI0CR2.byte =0xF8; 		//Select the serial bus interface mode
	Delay_24C02();
	Len = Length-1;
	i=0;
	//dummy
		Data[i] = SBI0DBR.byte;
		SBI0DBR.byte = 0x0;
		Delay_24C02();
	for(;i<Len;i++)
	{
		Data[i] = SBI0DBR.byte;
		SBI0DBR.byte = 0x0;
		Delay_24C02();
	
	}
	SBI0CR1.byte = 0x7;
	Data[i] = SBI0DBR.byte;
	SBI0DBR.byte = 0x0;
	Delay_NAK();
	SBI0CR1.byte = 0x27;
	tmp = SBI0DBR.byte;
	SBI0DBR.byte = 0x0;
	Delay_NAK();
	//stop
	// 
	SBI0CR2.byte =0xD8; // Sets SBI0CR2<MST>, <TRX> and <PIN> to "1" and SBI0CR2<BB> to "0"
	while(SBI0SR2.bit.b5==1){WDCDR.byte = 0x4e;}// Confirms that the bus is free
	Delay_24C02();
	__ASM("NOP");

}